% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GCMMplots.R
\name{circplotmeans}
\alias{circplotmeans}
\title{Circular plot of GCMM means}
\usage{
circplotmeans(
  models,
  col = c("cyan3", "orchid", "deeppink", "dodgerblue"),
  axisunits = c("radians", "sun", "time")
)
}
\arguments{
\item{models}{List of one or more objects of class \code{GCMM} containing output from the \code{\link{GCMM}} function}

\item{col}{Vector of colours to use in the plot}

\item{axisunits}{Units to be used for the axis, either "radians", "sun", or "time"}
}
\value{
Prints plot
}
\description{
Circular plot of GCMM means (circular intercepts)
}
\examples{
\donttest{ FoxActivityGCMM<-GCMM(data=redfoxsample$Radians, 
        RE1=redfoxsample$SamplingPeriod, family="vonmises", autorun=FALSE,
        adapt=0, sample=300, burnin=300, thin=1, n.chains=2)
     HumanActivityGCMM<-GCMM(data=humanssample$Radians, RE1=humanssample$SamplingPeriod, 
        family="vonmises", autorun=FALSE, adapt=0, sample=300, burnin=300, thin=1, n.chains=2)
    circplotmeans(models=list(FoxActivityGCMM,HumanActivityGCMM)) }

}
