% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc.R
\name{grad_est_subspace}
\alias{grad_est_subspace}
\title{Estimate the Active Subspace of a Cheap Function using Gradients}
\usage{
grad_est_subspace(f, r, m, M = NULL, scale = FALSE)
}
\arguments{
\item{f}{The function to eval}

\item{r}{The max dim of the active subspace}

\item{m}{The dimension of the underlying/embedding space.}

\item{M}{optional budget of evaluations, default to \code{2 * r * log(m)}}

\item{scale}{Scale all gradients to have norm 1?}
}
\value{
A list with sub, the active subspace, sv, the singular values (all m of them), fs, which gives function values, gs, function grads, and X, which gives sampled locations.
}
\description{
Looks between [-1, 1]
}
