% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mutate.R
\name{mutate_with_speed}
\alias{mutate_with_speed}
\title{Augments an \code{\link[=act_tbl-class]{act_tbl}} with a speed column}
\usage{
mutate_with_speed(df, method = c("2D", "3D"), lead = 0, lag = 1)
}
\arguments{
\item{df}{An \code{\link[=act_tbl-class]{act_tbl}} object}

\item{method}{If "2D" (default), ignores elevation. If "3D", includes
elevation. "3D" is not often necessary, but for skiing
activities is likely to yield a more accurate value.}

\item{lead}{How far ahead to look for the "end" point.}

\item{lag}{How far behind to look for the "start" point.}
}
\value{
That same \code{\link[=act_tbl-class]{act_tbl}}, but with a new \code{speed} column,
in meters per second.
}
\description{
This returns a mutated \code{\link[=act_tbl-class]{act_tbl}} with a new column
representing speed, in meters per second. See \code{vignette("pace")} for
examples.
}
\details{
The speed is determined by looking at the time difference
between the current point and the previous point: hence, it is always NA
for the first row in the data frame.

The \code{lead} and \code{lag} values are helpful to get "smoother" values, especially
if the provided activity file has GPS errors in it.
}
\examples{
example_gpx_file <- system.file(
  "extdata",
  "running_example.gpx.gz",
  package = "activatr"
)
example_act_tbl <- parse_gpx(example_gpx_file)
example_act_tbl_with_speed <- mutate_with_speed(example_act_tbl)
example_act_tbl_with_speed
}
