% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transcripts_update_fulltexts.R
\name{transcripts_update_fulltexts}
\alias{transcripts_update_fulltexts}
\title{Update full texts}
\usage{
transcripts_update_fulltexts(
  x,
  searchMode = c("fulltext", "fulltext.bytier", "fulltext.bytime"),
  transcriptNames = NULL,
  tierNames = NULL,
  forceUpdate = FALSE
)
}
\arguments{
\item{x}{Corpus object.}

\item{searchMode}{Character string; Which full text should be created; accepts the following values: \code{fulltext.bytier, fulltext.bytime, fulltext}.}

\item{transcriptNames}{Vector of character strings; Names of the transcripts you want to update; leave empty if you want to process all transcripts that need an update.}

\item{tierNames}{Vector of character strings; Names of the tiers to include in the fulltext.}

\item{forceUpdate}{Logical; If \code{TRUE} fulltexts will be created in any case, if \code{FALSE} fulltexts will be only be created if there was a modification to the transcript since the last creation of the fulltexts.}
}
\value{
Corpus object.
}
\description{
Creates/updates the full texts of the transcripts in a corpus.
The full text may be created in two different ways:
\itemize{
\item The contents of a transcription will be joined consecutively based on the time information.
\item The contents of each tier will be joined consecutively, and then the next tier will be joined.
}
}
\examples{
library(act)

examplecorpus <- act::transcripts_update_fulltexts(x=examplecorpus)

}
