\name{call_acm}
\alias{call_acm}
\title{Align-and-Count Method comparisons of RFLP data}
\usage{
call_acm(input, work_dir = ".", dnum = 1)
}
\arguments{
  \item{input}{The input file format for fragment and lane
  information are as the file example.in shows. Each line
  (record) should define a band. The file must be sorted so
  that the bands from a lane are together; the file must be
  sorted by unique lane identifier (ULI). There must be
  three fields (separated by white space -- that is,
  seperated by any combination of spaces and tabs). The
  first field must be the ULI. The second field is the gel
  image identifier (GII). This is only critical for the
  first fragment read in for the lane; for subsequent
  fragments, the second field must simply be present. ULI
  and GII names must not contain any spaces; I strongly
  suggest that these fields contain only letters, numbers,
  and underscore characters. The third field should contain
  the fragment length or molecular weight data for the
  fragment. Lines that cannot be parsed into these three
  fields will be recored in acm.log. Check acm.log after
  each run to see the number of lanes read in and to check
  for lines from the input file that could not be parsed.
  Lines must be no longer than 199 characters.}

  \item{work_dir}{This is where the work is being done}

  \item{dnum}{is the file number}
}
\value{
The output from acm or acmone gives a comparison of two
lanes on each line of output in the form: ULI ULI numbands
numbands num_matches The first field is identifier for the
first lane in the comparison. The third field is the number
of bands read in for this first lane. The second field is
the identifier for the second lane in the comparison. The
fourth field is the number of band read in for this second
lane. The fifth field is the number of fragments found to
match between the two lanes. The number of matches found
may be different depending on whether the lanes came from
the same gel image or from different gel images (see the
file acm.par).
}
\description{
Fragment lengths or molecular weights from pairs of lanes
are compared, and a number of matching bands are calculated
using the Align-and-Count Method. Band intensities are not
used in this method.This version of acm will perform all
distinct pairwise comparisons between lanes. The first lane
will be compared to all following lanes. The second lane
will be compared to the third, fourth, etc..
}
\note{
Requires a parameter file generated by
\code{\link{call_erra}}
}
\examples{
\dontshow{
(WD <- getwd())
if (!is.null(WD)) setwd(WD)
data(replicates.in)
write.table(replicates.in,  "replicates.in", quote=FALSE, row.names=FALSE)
data(experiments.in)
write.table(experiments.in, "experiments.in", quote=FALSE, row.names=FALSE)
call_erra("replicates.in",  dnum=1, sd=1, delete=TRUE)
}
#perform the basic pairwise comparison via the align and count algorithm
res1<-call_acm("experiments.in")
}
\author{
Andrea Benedetti \email{andrea.benedetti@mcgill.ca}

Sahir Rai Bhatnagar

XiaoFei Zhao
}
\references{
Salamon et. al (1998) Accommodating Error Analysis in
Comparison and Clustering of Molecular Fingerprints.
Emerging Infectious Diseases Vol. 4, No. 2, April-June 1998

Abasci LLC. JAMES v1.0 User Documentation. 2002.
}

