% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/acetest.R
\name{acetest}
\alias{acetest}
\alias{summary.acetest}
\alias{print.acetest}
\alias{plot.acetest}
\title{ACE permutation test of independence}
\usage{
acetest(x, y = NULL, nperm = 999, ...)

\method{summary}{acetest}(object, ..., digits)

\method{print}{acetest}(x, ...)

\method{plot}{acetest}(
  x,
  acol = "blue",
  xlim = c(min(x$tp), max(c(x$tp, ceiling(x$ace * 10)/10))),
  col = "black",
  breaks = 100,
  main = "ACE Correlation Permutations",
  xlab = bquote(rho(.(x$xname), .(x$yname))),
  lwd = 2,
  ...
)
}
\arguments{
\item{x}{a numeric vector, or a matrix or data frame with two columns. The
first column is the 'y' and the second column is the 'x' when
calling \code{\link{ace}}.}

\item{y}{a vector with same length as x. Default is NULL.}

\item{nperm}{number of permutations. Default is 999.}

\item{...}{additional arguments to pass to \code{cor}.}

\item{object}{S3 object of test results to dispatch.}

\item{digits}{Number of significant digits to round for summary.}

\item{acol}{for plot; color of the point estimate of correlation}

\item{xlim}{for plot;xlimit of histogram}

\item{col}{for plot;color of histogram bars}

\item{breaks}{for plot;number of breaks. Default to 100.}

\item{main}{for plot; main title of plot}

\item{xlab}{for plot; x-axis label}

\item{lwd}{for plot; line width of point estimate}
}
\value{
a list containing the following:
\itemize{
  \item{\code{ace}} The value of the test statistic.
  \item{\code{pval}} The *p*-value of the test.
}
}
\description{
Performs a permutation test of independence or association. The
  alternative hypothesis is that x and y are dependent. 
  
Code authored by Bernhard Klar, Shawn Garbett.
}
\examples{

n <- 200
z <- matrix(rnorm(2*n), n) / sqrt(rchisq(n, 2)/2)
x <- z[,2]; y <- z[,1]
cor.test(x, y, method="spearman")
acetest(x, y)

plot(acetest(z))
}
\references{
Holzmann, H., Klar, B. 2025. "Lancaster correlation - a new dependence measure
linked to maximum correlation". Scandinavian Journal of Statistics.
52(1):145-169 <doi:10.1111/sjos.12733>
}
\seealso{
\code{\link{cor}}
}
