% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/canvas_nebula.R
\name{canvas_nebula}
\alias{canvas_nebula}
\title{Paint a Nebula on a Canvas}
\usage{
canvas_nebula(colors, k = 50, n = 500, resolution = 2000)
}
\arguments{
\item{colors}{a string or character vector specifying the color(s) used for the artwork.}

\item{k}{a positive integer specifying the number of nearest neighbors to consider.}

\item{n}{a positive integer specifying the number of random data points to generate.}

\item{resolution}{a positive integer specifying the number of pixels (resolution x resolution) of the artwork.}
}
\value{
A \code{ggplot} object containing the artwork.
}
\description{
This function creates an artwork from randomly generated noise. Currently it is only capable of generating k-nearest neighbors noise. Sometimes, the noise resembles a nebula.
}
\examples{
\donttest{
set.seed(6)
palette <- colorPalette('random', n = 5)
canvas_nebula(colors = palette)
}

}
\author{
Koen Derks, \email{koen-derks@hotmail.com}
}
\keyword{artwork}
\keyword{canvas}
