% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Regular.R
\name{Regular}
\alias{Regular}
\alias{A051037}
\title{Regular numbers}
\usage{
Regular(n, Rmpfr = TRUE, PrecisionBits = 496)
}
\arguments{
\item{n}{the number of first \code{n} entries from the sequence.}

\item{Rmpfr}{a logical; \code{TRUE} to use large number representation, \code{FALSE} otherwise.}

\item{PrecisionBits}{a positive integer for precision bits larger than 2.}
}
\value{
a vector of length \code{n} containing first entries from the sequence.
}
\description{
Under OEIS \href{https://oeis.org/A051037}{A051037}, a \emph{Regular} number - also known as 5-smooth - is a positive integer that
even divide powers of 60, or equivalently, whose prime divisors are only 2,3, and 5. First 6 Regular numbers are 1, 2, 3, 4, 5, 6.
}
\examples{
## generate first 20 Regular numbers
first20 = Regular(20)

## print without trailing 0's.
print(first20, drop0trailing = TRUE)

}
