% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/wrappers.R
\name{setx}
\alias{setx}
\title{Setting Explanatory Variable Values}
\usage{
setx(obj, fn = NULL, data = NULL, cond = FALSE, ...)
}
\arguments{
\item{obj}{the saved output from zelig}

\item{fn}{a list of functions to apply to the data frame}

\item{data}{a new data frame used to set the values of
explanatory variables. If data = NULL (the default), the
data frame called in zelig is used}

\item{cond}{a logical value indicating whether unconditional
(default) or conditional (choose \code{cond = TRUE}) prediction
should be performed.  If you choose \code{cond = TRUE}, \code{setx}
will coerce \code{fn = NULL} and ignore the additional arguments in
\code{\dots}.  If \code{cond = TRUE} and \code{data = NULL},
\code{setx} will prompt you for a data frame.}

\item{...}{user-defined values of specific variables for overwriting the
default values set by the function \code{fn}.  For example, adding
\code{var1 = mean(data\$var1)} or \code{x1 = 12} explicitly sets the value
of \code{x1} to 12.  In addition, you may specify one explanatory variable
as a range of values, creating one observation for every unique value in
the range of values}
}
\value{
For unconditional prediction, \code{x.out} is a model matrix based
  on the specified values for the explanatory variables.  For multiple
  analyses (i.e., when choosing the \code{by} option in \code{\link{zelig}},
  \code{setx} returns the selected values calculated over the entire
  data frame.  If you wish to calculate values over just one subset of
  the data frame, the 5th subset for example, you may use:
  \code{x.out <- setx(z.out[[5]])}
}
\description{
The \code{setx} command uses the variables identified in
the \code{formula} generated by \code{zelig} and sets the values of
the explanatory variables to the selected values.  Use \code{setx}
after \code{zelig} and before \code{sim} to simulate quantities of
interest.
}
\examples{
# Unconditional prediction:
data(turnout)
z.out <- zelig(vote ~ race + educate, model = "logit", data = turnout)
x.out <- setx(z.out)
s.out <- sim(z.out, x = x.out)
}
\author{
Matt Owen \email{mowen@iq.harvard.edu}, Olivia Lau and Kosuke Imai
}
\seealso{
The full Zelig manual may be accessed online at
  \url{http://gking.harvard.edu/zelig}
}
\keyword{file}

