% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/indicator_max.R
\name{indicator_max}
\alias{indicator_max}
\title{The max performance indicator}
\usage{
indicator_max(
  DT,
  ColNameFactor,
  ColNameWeight = "weight",
  bounds = c(-10, 10),
  max_generations = 200,
  hard_limit = TRUE,
  wait_generations = 50,
  other_class = NULL
)
}
\arguments{
\item{DT}{a data table contains the factors and the response.}

\item{ColNameFactor}{a char vector with the name of the selected factor.}

\item{ColNameWeight}{a char with the name of the ZI response.}

\item{bounds}{default is $[-10;10]$. Upper and Lower bounds.}

\item{max_generations}{default is 200 see \link[rgenoud]{genoud} for more information.}

\item{hard_limit}{default is TRUE see \link[rgenoud]{genoud} for more information.}

\item{wait_generations}{default is 50 see \link[rgenoud]{genoud} for more information.}

\item{other_class}{a char vector with the name of other classes than numeric (factor or char).}
}
\value{
Return a list of two elements with the value of the indicator and the associate set of parameters (beta).
}
\description{
Search for the set of parameters that maximize the indicator (equivalent to Spearman correlation).
For a given set of factors scaled between 0 and 1 and a
zero-inflated proportions response.
}
\examples{
library(data.table)
data(example_data)
# For real cases increase max_generations and wait_generations
I_max = indicator_max(example_data,
names(example_data)[c(4:8, 14:18)],
ColNameWeight = "proba",
max_generations = 20,
wait_generations = 5)
print(I_max)
}
