% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DpqDistance.R
\name{DpqDistance}
\alias{DpqDistance}
\title{Function to calculate D(p,q) distance.}
\usage{
DpqDistance(value1, value2, p = 2, q = 1/2)
}
\arguments{
\item{value1}{First fuzzy number.}

\item{value2}{Second fuzzy number.}

\item{p}{Value of the power (and the the root) applied in the distance calculation.}

\item{q}{Value of the weight for the second fuzzy number (for the first one this weight is calculated as \code{1-q}, respectively).}
}
\value{
The output is a numerical value (the calculated distance).
}
\description{
\code{DpqDistance} calculates the generalized D(p,q) distance between two fuzzy numbers.
}
\details{
The function calculates the generalized D(p,q) distance between two fuzzy numbers \code{value1} and \code{value2},
where \code{p} is the value of the applied power, and \code{q} is the weight between these two fuzzy numbers.

All of the input values should be given by fuzzy numbers described by classes from \code{FuzzyNumbers} package.
}
\examples{


library(FuzzyNumbers)

# prepare two fuzzy numbers

A <- TrapezoidalFuzzyNumber(0,1,2,3)

B <- TrapezoidalFuzzyNumber(1,3,4,6)

# calculate the distance

DpqDistance (A,B)


}
