% Generated by roxygen2 (4.1.0.9001): do not edit by hand
% Please edit documentation in R/Interface.R
\name{valueFromServer}
\alias{valueFromServer}
\title{Convert the String Returned by a Server Language Interface to an R Object.}
\usage{
valueFromServer(string, key, get, evaluator, object)
}
\arguments{
\item{string}{the string to be passed to JSON.}

\item{key}{the key if a proxy was allowed, otherwise the empty string.}

\item{get}{the logical controling whether a proxy or a converted value was wanted.}

\item{evaluator}{the evaluator object that issued the server language expression.}

\item{object}{If JSON is not used, the call from the server language method should provide the
elementary conversion of the result (without using \code{asRObject()} and the string argument
should be omitted.  If JSON is used, \code{object} should be computed by default from JSON.}
}
\value{
the R object implied by the server result.
}
\description{
This is the conversion mechanism for results returned from a server language interface.
By default, JSON is used to decode the string.  Otherwise the result of the basic
decoding should be provided as argument \code{object}.
Should be called by the implementation of ServerEval for individual interface classes.
}
\references{
Chambers, John M. (2016)
\emph{Extending R},
Chapman & Hall/CRC.
( Chapter 12, discussing this package, is included in the package: \url{../doc/Chapter_XR.pdf}.)
}

