/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.poifs.crypt;

import org.apache.poi.EncryptedDocumentException;

public enum CipherProvider {
    rc4("RC4", 1),
    aes("AES", 24);

    public final String jceId;
    public final int ecmaId;

    public static CipherProvider fromEcmaId(int ecmaId) {
        for (CipherProvider cp : CipherProvider.values()) {
            if (cp.ecmaId != ecmaId) continue;
            return cp;
        }
        throw new EncryptedDocumentException("cipher provider not found");
    }

    private CipherProvider(String jceId, int ecmaId) {
        this.jceId = jceId;
        this.ecmaId = ecmaId;
    }
}

