/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.ss.usermodel;

import java.util.HashMap;
import java.util.Map;

public enum FormulaError {
    NULL(0, "#NULL!"),
    DIV0(7, "#DIV/0!"),
    VALUE(15, "#VALUE!"),
    REF(23, "#REF!"),
    NAME(29, "#NAME?"),
    NUM(36, "#NUM!"),
    NA(42, "#N/A");

    private byte type;
    private String repr;
    private static Map<String, FormulaError> smap;
    private static Map<Byte, FormulaError> imap;

    private FormulaError(int type, String repr) {
        this.type = (byte)type;
        this.repr = repr;
    }

    public byte getCode() {
        return this.type;
    }

    public String getString() {
        return this.repr;
    }

    public static FormulaError forInt(byte type) {
        FormulaError err = imap.get(type);
        if (err == null) {
            throw new IllegalArgumentException("Unknown error type: " + type);
        }
        return err;
    }

    public static FormulaError forString(String code) {
        FormulaError err = smap.get(code);
        if (err == null) {
            throw new IllegalArgumentException("Unknown error code: " + code);
        }
        return err;
    }

    static {
        smap = new HashMap<String, FormulaError>();
        imap = new HashMap<Byte, FormulaError>();
        for (FormulaError error : FormulaError.values()) {
            imap.put(error.getCode(), error);
            smap.put(error.getString(), error);
        }
    }
}

