% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xSNPscores.r
\name{xSNPscores}
\alias{xSNPscores}
\title{Function to score lead or LD SNPs based on the given significance level}
\usage{
xSNPscores(
data,
include.LD = NA,
LD.customised = NULL,
LD.r2 = 0.8,
significance.threshold = 5e-05,
score.cap = 10,
verbose = T,
RData.location = "http://galahad.well.ox.ac.uk/bigdata",
guid = NULL
)
}
\arguments{
\item{data}{a named input vector containing the significance level for
nodes (dbSNP). For this named vector, the element names are dbSNP
(starting with rs or in the format of 'chrN:xxx', where N is either
1-22 or X, xxx is number; for example, 'chr16:28525386'), the element
values for the significance level (measured as p-value or fdr).
Alternatively, it can be a matrix or data frame with two columns: 1st
column for dbSNP, 2nd column for the significance level.}

\item{include.LD}{additional SNPs in LD with Lead SNPs are also
included. By default, it is 'NA' to disable this option. Otherwise, LD
SNPs will be included based on one or more of 26 populations and 5
super populations from 1000 Genomics Project data (phase 3). The
population can be one of 5 super populations ("AFR", "AMR", "EAS",
"EUR", "SAS"), or one of 26 populations ("ACB", "ASW", "BEB", "CDX",
"CEU", "CHB", "CHS", "CLM", "ESN", "FIN", "GBR", "GIH", "GWD", "IBS",
"ITU", "JPT", "KHV", "LWK", "MSL", "MXL", "PEL", "PJL", "PUR", "STU",
"TSI", "YRI"). Explanations for population code can be found at
\url{http://www.1000genomes.org/faq/which-populations-are-part-your-study}}

\item{LD.customised}{a user-input matrix or data frame with 3 columns:
1st column for Lead SNPs, 2nd column for LD SNPs, and 3rd for LD r2
value. It is designed to allow the user analysing their precalcuated LD
info. This customisation (if provided) has the high priority over
built-in LD SNPs}

\item{LD.r2}{the LD r2 value. By default, it is 0.8, meaning that SNPs
in LD (r2>=0.8) with input SNPs will be considered as LD SNPs. It can
be any value from 0.8 to 1}

\item{significance.threshold}{the given significance threshold. By
default, it is set to NULL, meaning there is no constraint on the
significance level when transforming the significance level of SNPs
into scores. If given, those SNPs below this are considered significant
and thus scored positively. Instead, those above this are considered
insigificant and thus receive no score}

\item{score.cap}{the maximum score being capped. By default, it is set
to 10. If NULL, no capping is applied}

\item{verbose}{logical to indicate whether the messages will be
displayed in the screen. By default, it sets to true for display}

\item{RData.location}{the characters to tell the location of built-in
RData files. See \code{\link{xRDataLoader}} for details}

\item{guid}{a valid (5-character) Global Unique IDentifier for an OSF
project. See \code{\link{xRDataLoader}} for details}
}
\value{
a data frame with following columns:
\itemize{
\item{\code{SNP}: Lead and/or LD SNPs}
\item{\code{Score}: the scores for SNPs calculated based on p-values
taking into account the given threshold of the significant level}
\item{\code{Pval}: the input p-values for Lead SNPs or R2-adjusted
p-values for LD SNPs}
\item{\code{Flag}: the flag to indicate whether the resulting SNPs are
Lead SNPs or LD SNPs}
}
}
\description{
\code{xSNPscores} is supposed to score a list of Lead SNPs together
with the significance level. It can consider LD SNPs and the given
threshold of the significant level.
}
\note{
None
}
\examples{
\dontrun{
# Load the XGR package and specify the location of built-in data
library(XGR)
}
RData.location <- "http://galahad.well.ox.ac.uk/bigdata"

\dontrun{
# a) provide the seed SNPs with the significance info
## load ImmunoBase
ImmunoBase <- xRDataLoader(RData.customised='ImmunoBase',
RData.location=RData.location)
## get lead SNPs reported in AS GWAS and their significance info (p-values)
gr <- ImmunoBase$AS$variant
data <- GenomicRanges::mcols(gr)[,c(1,3)]

# b) calculate SNP scores (considering significant cutoff 5e-5)
## without inclusion of LD SNPs
df_SNP <- xSNPscores(data=data, significance.threshold=5e-5,
RData.location=RData.location)
## include LD SNPs (calculated based on European populations)
df_SNP <- xSNPscores(data=data, significance.threshold=5e-5,
include.LD="EUR", RData.location=RData.location)
}
}
\seealso{
\code{\link{xRDataLoader}}
}
