% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/WP_rsquared.R
\name{plot,WPR2-method}
\alias{plot,WPR2-method}
\title{Plot Function for \eqn{W_p R^2} Objects}
\usage{
\S4method{plot}{WPR2}(
  x,
  xlim = NULL,
  ylim = NULL,
  linesize = 0.5,
  pointsize = 1.5,
  facet.group = NULL,
  ...
)
}
\arguments{
\item{x}{A \eqn{W_p R^2} object}

\item{xlim}{x-axis limits}

\item{ylim}{y-axis limits}

\item{linesize}{Linesize for \link[ggplot2]{geom_line}}

\item{pointsize}{Point size for \link[ggplot2]{geom_point}}

\item{facet.group}{Group to do facet_grid by}

\item{...}{Currently not used}
}
\value{
a \code{\link[ggplot2:ggplot]{ggplot2::ggplot()}} object
}
\description{
Plot Function for \eqn{W_p R^2} Objects
}
\examples{
n <- 128
p <- 10
s <- 99
x <- matrix( stats::rnorm( p * n ), nrow = n, ncol = p )
beta <- (1:10)/10
y <- x \%*\% beta + stats::rnorm(n)
post_beta <- matrix(beta, nrow=p, ncol=s) + stats::rnorm(p*s, 0, 0.1)
post_mu <- x \%*\% post_beta

fit <-  WpProj(X=x, eta=post_mu, power = 2.0,
               options = list(penalty = "lasso")
)
obj <- WPR2(predictions = post_mu, projected_model = fit)
p <- plot(obj)
}
