% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{extract_claims}
\alias{extract_claims}
\title{Extract Claims from Returned Item Data}
\usage{
extract_claims(items, claims)
}
\arguments{
\item{items}{a list of one or more Wikidata items returned with
\code{\link{get_item}}.}

\item{claims}{a vector of claims (in the form "P321", "P12") to look for
and extract.}
}
\value{
a list containing one sub-list for each entry in \code{items},
and (below that) the found data for each claim. In the event a claim
cannot be found for an item, an \code{NA} will be returned
instead.
}
\description{
extract claim information from data returned using
\code{\link{get_item}}.
}
\examples{
# Get item data
adams_data <- get_item("42")
# Get claim data
claims <- extract_claims(adams_data, "P31")
}
