% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sunburst.R
\name{sunburstTreemap}
\alias{sunburstTreemap}
\title{sunburstTreemap}
\usage{
sunburstTreemap(
  data,
  levels,
  fun = sum,
  sort = TRUE,
  filter = 0,
  cell_size = NULL,
  custom_color = NULL,
  diameter_inner = 0.3,
  diameter_outer = 0.8,
  verbose = FALSE
)
}
\arguments{
\item{data}{(data.frame) A data.frame with one column for each hierarchical level}

\item{levels}{(character) Character vector indicating the column names to 
be used. The order of names must correspond to the hierarchical levels, 
going from broad to fine}

\item{fun}{(function) Function to be used to aggregate cell sizes of parental cells}

\item{sort}{(logical) Should the columns of the data.frame be sorted before?}

\item{filter}{(logical) Filter the supplied data frame to remove very small
sectors that may not be visible. The default is to not remove any sectors.}

\item{cell_size}{(character) The name of the column used to control sector size. 
Can be one of \code{levels} or any other column with numerical data. NA or
values equal or less than zero are not allowed.
The values in this column are aggregated by the function specified by \code{fun}.
If \code{sector_size = NULL}, sector size is simply computed by the number of members
for the respective sector (corresponding to rows in the data.frame).}

\item{custom_color}{(character) An optional column that can be specified to
control cell color. Cell colors are determined when drawing the treemap
using \code{\link{drawTreemap}}, but the default is to use one of 
\code{levels} or \code{cell size}. Any other data source that shall be used
instead has to be included in the treemap generation and explicitly 
specified here. The default value is \code{NULL}.}

\item{diameter_inner}{(numeric) The minimum inner diameter of the drawn map. 
Defaults to 0.3,}

\item{diameter_outer}{(numeric) The maximum outer diameter of the drawn map. 
Defaults to 0.8}

\item{verbose}{(logical) If verbose is TRUE (default is FALSE), basic information
such as a success message is printed to the console.}
}
\value{
`sunburstTreemap` returns an object of the formal class `sunburstResult`.
  It is essentially a list of objects related to the graphical
  representation of the treemap (polygons, labels, cell data) as well as data from the call
  of the function. It contains the following slots:
    \item{cells}{`list` of polygons for drawing a treemap}
    \item{data}{`data.frame`, the original data that was supplied to calling `voronoiTreemap`}
    \item{call}{`list` of arguments used to call `voronoiTreemap`}
}
\description{
Create sunburst treemaps where variables are encoded by size of circular sectors.
}
\details{
This function returns a treemap object instead of a plot. In order 
to actually draw the treemap, use \code{\link{drawTreemap}}.
}
\examples{
# load example data
data(mtcars)
mtcars$car_name = gsub(" ", "\n", row.names(mtcars))

# generate treemap;
# by default cell (sector) size is encoded by number of members per group
tm <- sunburstTreemap(
  data = mtcars,
  levels = c("gear", "cyl"),
  cell_size = "hp"
)

# draw treemap with default options
drawTreemap(tm,
  title = "A sunburst treemap",
  legend = TRUE,
  border_size = 2,
  layout = c(1, 3),
  position = c(1, 1)
)

# use custom color palette
drawTreemap(tm,
  title = "Use custom palette",
  legend = TRUE,
  color_palette = rep(c("#81E06E", "#E68CFF", "#76BBF7"), c(3, 4, 5)),
  border_size = 2,
  label_level = 2,
  label_size = 0.7,
  label_color = grey(0.5),
  layout = c(1, 3),
  position = c(1, 2),
  add = TRUE
)

# color cells (sectors) based on cell size
drawTreemap(tm,
  title = "Coloring encoded by cell size",
  color_type = "cell_size",
  legend = TRUE,
  color_palette = rev(heat.colors(10)),
  border_size = 3,
  border_color = grey(0.3),
  label_level = 1,
  label_size = 2,
  label_color = grey(0.5),
  layout = c(1, 3),
  position = c(1, 3),
  add = TRUE
)

}
\seealso{
\code{\link{drawTreemap}} for drawing the treemap.
}
