% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.glm_weightit.R
\name{predict.glm_weightit}
\alias{predict.glm_weightit}
\alias{predict.ordinal_weightit}
\alias{predict.multinom_weightit}
\title{Predictions for \code{glm_weightit} objects}
\usage{
\method{predict}{glm_weightit}(object, newdata = NULL, type = "response", na.action = na.pass, ...)

\method{predict}{ordinal_weightit}(
  object,
  newdata = NULL,
  type = "response",
  na.action = na.pass,
  values = NULL,
  ...
)

\method{predict}{multinom_weightit}(
  object,
  newdata = NULL,
  type = "response",
  na.action = na.pass,
  values = NULL,
  ...
)
}
\arguments{
\item{object}{a \code{glm_weightit} object.}

\item{newdata}{optionally, a data frame in which to look for variables with
which to predict. If omitted, the fitted values applied to the original
dataset are used.}

\item{type}{the type of prediction desired. Allowable options include
\code{"response"}, predictions on the scale of the original response variable
(also \code{"probs"}); \code{"link"}, predictions on the scale of the linear
predictor (also \code{"lp"}); \code{"class"}, the modal predicted category for
ordinal and multinomial models; and \code{"mean"}, the expected value of the
outcome for ordinal and multinomial models. See Details for more
information. The default is \code{"response"} for all models, which differs from
\code{\link[stats:predict.glm]{stats::predict.glm()}}.}

\item{na.action}{function determining what should be done with missing values
in \code{newdata}. The default is to predict \code{NA}.}

\item{\dots}{further arguments passed to or from other methods.}

\item{values}{when \code{type = "mean"}, the numeric values each level corresponds
to. Should be supplied as a named vector with outcome levels as the names.
If \code{NULL} and the outcome levels can be converted to numeric, those will be
used. See Details.}
}
\value{
A numeric vector containing the desired predictions, except for the
following circumstances when an ordinal or multinomial model was fit:
\itemize{
\item when \code{type = "response"}, a numeric matrix with a row for each unit and
a column for each level of the outcome with the predicted probability of
the corresponding outcome in the cells
\item when \code{type = "class"}, a factor with the model predicted class for each
unit; for ordinal models, this will be an ordered factor.
}
}
\description{
\code{predict()} generates predictions for models fit using
\code{glm_weightit()}, \code{ordinal_weightit()}, \code{multinom_weightit()}, or
\code{coxph_weightit()}. This page only details the \code{predict()} methods after
using \code{glm_weightit()}, \code{ordinal_weightit()}, or \code{multinom_weightit()}. See
\code{\link[survival:predict.coxph]{survival::predict.coxph()}} for predictions when fitting Cox proportional
hazards models using \code{coxph_weightit()}.
}
\details{
For generalized linear models other than ordinal and multinomial
models, see \code{\link[stats:predict.glm]{stats::predict.glm()}} for more information on how predictions
are computed and which arguments can be specified. Note that standard errors
cannot be computed for the predictions using \code{predict.glm_weightit()}.

For ordinal and multinomial models, setting \code{type = "mean"} computes the
expected value of the outcome for each unit; this corresponds to the sum of
the values supplied in \code{values} weighted by the predicted probability of
those values. If \code{values} is omitted, \code{predict()} will attempt to convert the
outcome levels to numeric values, and if this cannot be done, an error will
be thrown. \code{values} should be specified as a named vector, e.g., \code{values = c(one = 1, two = 2, three = 3)}, where \code{"one"}, \code{"two"}, and \code{"three"} are
the original outcome levels and 1, 2, and 3 are the numeric values they
correspond to. This method only makes sense to use if the outcome levels
meaningfully correspond to numeric values.

For ordinal models, setting \code{type = "link"} (also \code{"lp"}) computes the linear
predictor without including the thresholds. This can be interpreted as the
prediction of the latent variable underlying the ordinal response. This
cannot be used with multinomial models.
}
\examples{
data("lalonde", package = "cobalt")

# Logistic regression model
fit1 <- glm_weightit(
  re78 > 0 ~ treat * (age + educ + race + married +
                        re74 + re75),
  data = lalonde, family = binomial, vcov = "none")

summary(predict(fit1))

# G-computation using predicted probabilities
p0 <- predict(fit1, type = "response",
              newdata = transform(lalonde,
                                  treat = 0))

p1 <- predict(fit1, type = "response",
              newdata = transform(lalonde,
                                  treat = 1))

mean(p1) - mean(p0)

# Multinomial logistic regression model
lalonde$re78_3 <- factor(findInterval(lalonde$re78,
                                      c(0, 5e3, 1e4)),
                         labels = c("low", "med", "high"))

fit2 <- multinom_weightit(
  re78_3 ~ treat * (age + educ + race + married +
                      re74 + re75),
  data = lalonde, vcov = "none")

# Predicted probabilities
head(predict(fit2))

# Class assignment accuracy
mean(predict(fit2, type = "class") == lalonde$re78_3)

# G-computation using expected value of the outcome
values <- c("low" = 2500,
            "med" = 7500,
            "high" = 12500)

p0 <- predict(fit2, type = "mean", values = values,
              newdata = transform(lalonde,
                                  treat = 0))

p1 <- predict(fit2, type = "mean", values = values,
              newdata = transform(lalonde,
                                  treat = 1))

mean(p1) - mean(p0)
\donttest{
# Ordinal logistic regression
fit3 <- ordinal_weightit(
  re78 ~ treat * (age + educ + race + married +
                    re74 + re75),
  data = lalonde, vcov = "none")

# G-computation using expected value of the outcome;
# using original outcome values
p0 <- predict(fit3, type = "mean",
              newdata = transform(lalonde,
                                  treat = 0))

p1 <- predict(fit3, type = "mean",
              newdata = transform(lalonde,
                                  treat = 1))

mean(p1) - mean(p0)
}
}
\seealso{
\code{\link[stats:predict.glm]{stats::predict.glm()}} for predictions from generalized linear
models. \code{\link[=glm_weightit]{glm_weightit()}} for the fitting function.
\code{\link[survival:predict.coxph]{survival::predict.coxph()}} for predictions from Cox proportional hazards
models.
}
