% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/WeightIt-package.R
\docType{package}
\name{WeightIt-package}
\alias{WeightIt}
\alias{WeightIt-package}
\title{WeightIt: Weighting for Covariate Balance in Observational Studies}
\description{
\if{html}{\figure{logo.png}{options: style='float: right' alt='logo' width='120'}}

Generates balancing weights for causal effect estimation in observational studies with binary, multi-category, or continuous point or longitudinal treatments by easing and extending the functionality of several R packages and providing in-house estimation methods. Available methods include propensity score weighting using generalized linear models, gradient boosting machines, the covariate balancing propensity score algorithm, inverse probability tilting, Bayesian additive regression trees, and SuperLearner, and directly estimating balancing weights using entropy balancing, energy balancing, and optimization-based weights. Also allows for assessment of weights and checking of covariate balance by interfacing directly with the 'cobalt' package. See the vignette "Installing Supporting Packages" for instructions on how to install any package 'WeightIt' uses, including those that may not be on CRAN.
}
\seealso{
Useful links:
\itemize{
  \item \url{https://ngreifer.github.io/WeightIt/}
  \item \url{https://github.com/ngreifer/WeightIt}
  \item Report bugs at \url{https://github.com/ngreifer/WeightIt/issues}
}

}
\author{
\strong{Maintainer}: Noah Greifer \email{noah.greifer@gmail.com} (\href{https://orcid.org/0000-0003-3067-7154}{ORCID})

}
\keyword{internal}
