% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/smear.R
\name{smear}
\alias{smear}
\title{Split the values of entries in a matrix between a specified area round it.}
\usage{
smear(M, r1, r2)
}
\arguments{
\item{M}{A matrix with real numbers as entries.}

\item{r1}{Integer specifying the range of the split in the horizontal direction.}

\item{r2}{Integer specifying the range of the split in the vertical direction.}
}
\value{
A matrix of the same dimensions as M, which had the mass split applied to all entries simultaneously.
}
\description{
Takes a matrix M and splits the value of the matrix at a given coordinate (i,j) with a rectangle of 
positions around it given by r1 and r2. The position (i,j) will get its previous value divided by (r1 x r2) and the 
surrounding positions (r1 in horizontal and r2 in vertical direction) will have their entries increased by the same value.
}
