% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/familyWALS.R, R/walsGLM.R
\name{familyWALS}
\alias{familyWALS}
\alias{familyWALScount}
\alias{poissonWALS}
\alias{binomialWALS}
\alias{negbinFixedWALS}
\alias{negbinWALS}
\alias{familyNBWALS}
\alias{familyWALS.walsGLM}
\title{Extended Family Objects for Models}
\usage{
familyWALS(object, ...)

poissonWALS(link = "log")

binomialWALS(link = "logit")

negbinFixedWALS(scale, link)

negbinWALS(scale, link)

\method{familyWALS}{walsGLM}(object, ...)
}
\arguments{
\item{object}{The function \code{familyWALS()} extracts the family objects stored
in \code{"walsGLM"} objects.}

\item{...}{Further arguments passed to methods.

The \code{negbinWALS()} family currently only accepts \code{"log"}, while
\code{negbinFixedWALS()} supports both \code{"log"} and \code{"canonical"}.}

\item{link}{Specifies the model link function. Typically a character string
or an object of class \code{"link-glm"} generated by
\code{\link[stats]{make.link}}. See \code{\link[stats]{family}} for more details.
Currently, only a limited number of links are supported. See below for more
details.}

\item{scale}{dispersion parameter of NB2 to be used, always larger than 0.}
}
\value{
An object of class \code{"familyWALS"} to be used in
\code{\link[WALS]{walsGLM}} that inherits from \code{"\link[stats]{family}"}.
This is a list that contains elements returned from the corresponding family
function that it extends. Additionally, the following elements are available:
\item{theta.eta}{function. Derivative of the canonical parameter \eqn{\theta}
with respect to the linear link \eqn{\eta}, i.e. \eqn{d \theta / d \eta}.}
\item{psi}{function. \eqn{\psi} defined on p. 3 of \insertCite{deluca2018glm}{WALS}.}
\item{initializeY}{function. Preprocesses the response, e.g. in
\code{binomialWALS()} it transforms factors to numeric 0s and 1s.}
\item{transformY}{function. Transforms the response to \eqn{\bar{y}}.
See eq. (5) in \insertCite{deluca2018glm}{WALS} for GLMs and
\insertCite{huynhwalsnb}{WALS} for \code{negbinWALS()} used in
\code{\link[WALS]{walsNB}}.}
\item{transformX}{function. Transforms the regressors to \eqn{\bar{X}_1} and
\eqn{\bar{X}_2}, respectively. See eq. (5) in \insertCite{deluca2018glm}{WALS}
for GLMs and \insertCite{huynhwalsnb}{WALS} for \code{negbinWALS()} used in
\code{\link[WALS]{walsNB}}.}
\item{density}{function. The probability density/mass function of the family.}

\code{poissonWALS()} and \code{negbinFixedWALS()} return objects of class
\code{"familyWALScount"} that inherit from \code{"familyWALS"} and
\code{"family"}. These are lists that contain the same elements as
\code{"familyWALS"} objects described above.

\code{negbinWALS()} creates an object of class \code{"familyNBWALS"}
(only used internally in \code{\link[WALS]{walsNB}}) that inherits from
\code{"familyWALScount"}, \code{"familyWALS"} and \code{"\link[stats]{family}"}.
This is a list that contains all elements returned from \code{negbinFixed}
and the elements described above for objects of class \code{"familyWALS"}.
Additionally contains the following elements with functions required in
\code{\link[WALS]{walsNB}} that are described in
\insertCite{huynhwalsnb}{WALS}:
\item{q}{function. Computes \eqn{\bar{q}}.}
\item{g}{function. Computes \eqn{\bar{g}}.}
\item{transformY0}{function. Computes \eqn{\bar{y}_0}.}
\item{t}{function. Computes \eqn{\bar{t}}.}
\item{epsilon}{function. Computes \eqn{\bar{\epsilon}}.}
\item{epsiloninv}{function. Computes \eqn{\bar{\epsilon}^{-1}}.}
\item{kappaSum}{function. Computes \eqn{\bar{\kappa}^{\top} \mathbf{1}}.}
\item{computeAlpha}{function. Computes the log-dispersion parameter
\eqn{\log(\rho)} given (model-averaged) estimates of the regression
coefficients of the transformed regressors \eqn{\gamma_{1}} and \eqn{\gamma_{2}}.}
}
\description{
Objects of class \code{"familyWALS"} inherit from \code{"\link[stats]{family}"}
and extend those with (transformation) functions required for
\code{\link[WALS]{walsGLM}} and \code{\link[WALS]{walsNB}}.
}
\details{
\code{familyWALS()} is a generic function that extracts the family used in
\code{"walsGLM"} objects.

\code{negbinFixedWALS()} creates the \code{"familyWALS"} object for negative
binomial distribution type 2 (NB2) with fixed dispersion parameter. It extends
\code{\link[WALS]{negativeBinomial}}.

\code{negbinWALS()} creates objects of the specialized class \code{"familyNBWALS"}
which inherits from \code{"familyWALS"} and \code{"family"}. It constructs the
\code{"familyNBWALS"} object for the negative binomial distribution type 2 (NB2)
with variable dispersion parameter by extending \code{\link[WALS]{negativeBinomial}}
and \code{negbinFixedWALS} with functions required in \code{\link[WALS]{walsNB}.}
\strong{\code{negbinWALS} should only be used in \code{\link[WALS]{walsNBfit}} and
not in \code{\link[WALS]{walsGLM}} because the NB2 with variable dispersion
parameter is not a GLM!}
\subsection{Supported links}{

Currently, \code{binomialWALS()} and \code{poissonWALS()} only support their
canonical links, i.e. \code{"logit"} and \code{"log"}, respectively.
\code{negbinFixedWALS()} supports both, the \code{"canonical"} link and
the \code{"log"} link, however, the first is not recommended due to numerical
difficulties in the fitting process. In contrast, \code{negbinWALS()} only
supports the \code{"log"} link.
}
}
\examples{
## Use in walsGLM():
data("NMES1988", package = "AER")
NMES1988 <- na.omit(NMES1988)
fitPoisson <- walsGLM(emergency ~ health + chronic + age + gender |
                       I((age^2)/10) + married + region, family = poissonWALS(),
                      data = NMES1988, prior = laplace())
summary(fitPoisson)

## Plot derivatives of binomialWALS() with default 'logit' link:
bi <- binomialWALS()
plot(bi$mu.eta, from = -10, to = 10)
plot(bi$theta.eta, from = -10, to = 10) # constant. logit is canonical link

}
\references{
\insertAllCited{}
}
\seealso{
\link{family}, \link{walsGLM}.
}
