% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods_predict.R
\name{predict.visitation_model}
\alias{predict.visitation_model}
\title{Predict Visitation Model}
\usage{
\method{predict}{visitation_model}(
  object,
  n_ahead,
  only_new = TRUE,
  difference = FALSE,
  past_observations = c("fitted", "reference"),
  ...
)
}
\arguments{
\item{object}{An object of class "visitation_model".}

\item{n_ahead}{An integer indicating how many observations to forecast.}

\item{only_new}{A Boolean specifying whether to include only the forecasts (if TRUE) or the full reconstruction (if FALSE). The default option is TRUE.}

\item{difference}{A Boolean specifying whether to forecast differences (if TRUE) or the original series (if FALSE). The default option is FALSE.}

\item{past_observations}{A character string; one of "fitted" or "reference". Here, "fitted" uses the fitted values of the visitation model, while "reference" uses values supplied in `ref_series'.}

\item{...}{Additional arguments.}
}
\value{
A predictions for the automatic decomposition.
\item{forecasts}{A vector with forecast values.}
\item{n_ahead}{A numeric that shows the number of steps ahead.}
\item{proxy_forecasts}{A vector for the proxy of trend forecasts.}
\item{onsite_usage_forecasts}{A vector for the visitation forecasts.}
\item{beta}{A numeric for the seasonality adjustment factor.}
\item{constant}{A numeric for the value of the constant in the model.}
\item{slope}{A numeric for the value of the slope term in the model when trend is set to "linear".}
\item{criterion}{A string which specifies the method used to select the appropriate lag. Only applicable if the trend component is part of the forecasts.}
\item{past_observations}{A vector which specifies the fitted values for the past observations.}
\item{lag_estimate}{A numeric for the estimated lag. Only applicable if the trend component is part of the forecasts.}
}
\description{
Methods for generating predictions from objects of the class "visitation_model".
}
\examples{

data("park_visitation")
data("flickr_userdays")

n_ahead <- 36
park <- "ROMO"
pud_ts <- ts(park_visitation[park_visitation$park == park,]$pud, start = 2005, frequency = 12)
pud_ts <- log(pud_ts)

nps_ts <- ts(park_visitation[park_visitation$park == park,]$nps, start = 2005, frequency = 12)
nps_ts <- log(nps_ts)
popularity_proxy <- log(flickr_userdays)

vm <- visitation_model(pud_ts,popularity_proxy, ref_series = nps_ts, trend = "linear")
predict_vm <- predict(vm,n_ahead, difference = TRUE,
                      only_new = FALSE, past_observations = "reference")
plot(predict_vm, difference = FALSE)
predict_vm2 <- predict(vm,n_ahead, difference = TRUE,
                       only_new = FALSE, past_observations = "reference")
plot(predict_vm2, difference = FALSE)
}
