% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GetGenerations.R
\name{GetGenerations}
\alias{GetGenerations}
\title{Builds a Multi-Generation Virtual Population from demographic parameters}
\usage{
GetGenerations(rates, ncohort = NULL, ngen = NULL, mort = NULL)
}
\arguments{
\item{rates}{List object with death rates (ASDR) and birth rates (ASFR). Produced by function VirtualPop::GetRates(). Rates of USA 2021 are distributed with the VirtualPop package.}

\item{ncohort}{Size of hypothetical birth cohort (first generation)}

\item{ngen}{Number of generations to be simulated. No upper limit.}

\item{mort}{Presence or absence of mortality. This parameter is optional. Default is TRUE. If mortality is absent, mort=FALSE.}
}
\value{
\item{dataAllgen}{The database of simulated individual lifespans and
fertility histories (all generations).}
The object dataAllgen has four attributes:
\item{country}{The country}
\item{type}{The type of data (period data or cohort data).}
\item{refyear}{The calendar year for which the period data are used (reference year).}
\item{cohort}{The birth cohort (if applicable).}
}
\description{
Builds a virtual population from mortality rates by age and sex, and fertility
rates by age of mother and parity.
}
\examples{


utils::data(rates,package = "VirtualPop")
dLH <- VirtualPop::GetGenerations (rates=rates,ncohort=1000,ngen=4)


}
