% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BiCopCheck.R
\name{BiCopCheck}
\alias{BiCopCheck}
\title{Check for family/parameter consistency in bivariate copula models}
\usage{
BiCopCheck(family, par, par2 = 0, ...)
}
\arguments{
\item{family}{An integer defining the bivariate copula family: \cr
\code{0} = independence copula \cr
\code{1} = Gaussian copula \cr
\code{2} = Student t copula (t-copula) \cr
\code{3} = Clayton copula \cr
\code{4} = Gumbel copula \cr
\code{5} = Frank copula \cr
\code{6} = Joe copula \cr
\code{7} = BB1 copula \cr
\code{8} = BB6 copula \cr
\code{9} = BB7 copula \cr
\code{10} = BB8 copula \cr
\code{13} = rotated Clayton copula (180 degrees; \verb{survival Clayton'') \\cr `14` = rotated Gumbel copula (180 degrees; }survival Gumbel'') \cr
\code{16} = rotated Joe copula (180 degrees; \verb{survival Joe'') \\cr `17` = rotated BB1 copula (180 degrees; }survival BB1'')\cr
\code{18} = rotated BB6 copula (180 degrees; \verb{survival BB6'')\\cr `19` = rotated BB7 copula (180 degrees; }survival BB7'')\cr
\code{20} = rotated BB8 copula (180 degrees; ``survival BB8'')\cr
\code{23} = rotated Clayton copula (90 degrees) \cr
`24` = rotated Gumbel copula (90 degrees) \cr
`26` = rotated Joe copula (90 degrees) \cr
`27` = rotated BB1 copula (90 degrees) \cr
`28` = rotated BB6 copula (90 degrees) \cr
`29` = rotated BB7 copula (90 degrees) \cr
`30` = rotated BB8 copula (90 degrees) \cr
`33` = rotated Clayton copula (270 degrees) \cr
`34` = rotated Gumbel copula (270 degrees) \cr
`36` = rotated Joe copula (270 degrees) \cr
`37` = rotated BB1 copula (270 degrees) \cr
`38` = rotated BB6 copula (270 degrees) \cr
`39` = rotated BB7 copula (270 degrees) \cr
`40` = rotated BB8 copula (270 degrees) \cr
`104` = Tawn type 1 copula \cr
`114` = rotated Tawn type 1 copula (180 degrees) \cr
`124` = rotated Tawn type 1 copula (90 degrees) \cr
`134` = rotated Tawn type 1 copula (270 degrees) \cr
`204` = Tawn type 2 copula \cr
`214` = rotated Tawn type 2 copula (180 degrees) \cr
`224` = rotated Tawn type 2 copula (90 degrees) \cr
`234` = rotated Tawn type 2 copula (270 degrees) \cr}

\item{par}{Copula parameter.}

\item{par2}{Second parameter for bivariate copulas with two parameters (t,
BB1, BB6, BB7, BB8, Tawn type 1 and type 2; default is \code{par2 = 0}).}

\item{\dots}{used internally.}
}
\value{
A logical indicating whether the family can be used with the parameter
specification.
}
\description{
The function checks if a certain combination of copula family and parameters
can be used within other functions of this package.
}
\examples{
## check parameter of Clayton copula
BiCopCheck(3, 1)  # works

\dontrun{BiCopCheck(3, -1)  # does not work (only positive parameter is allowed)}

}
\author{
Thomas Nagler
}
