% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vli.R
\name{01. Basics}
\alias{01. Basics}
\alias{as.vli}
\alias{as.vli.default}
\alias{as.vli.character}
\alias{as.vli.numeric}
\alias{asnumeric}
\alias{asnumeric.default}
\alias{asnumeric.vli}
\alias{as.integer.vli}
\alias{as.character.vli}
\alias{vli}
\alias{print.vli}
\alias{is.vli}
\title{Very Large Integers Basics}
\usage{
as.vli(n)

\method{as.vli}{default}(n)

\method{as.vli}{character}(n)

\method{as.vli}{numeric}(n)

asnumeric(x)

\method{asnumeric}{default}(x)

\method{asnumeric}{vli}(x)

\method{as.integer}{vli}(x, ...)

\method{as.integer}{vli}(x, ...)

vli(m)

\method{print}{vli}(x, ...)

is.vli(x)
}
\arguments{
\item{n}{value for the vli object being created; character or numeric}

\item{x}{object of class vli}

\item{...}{further arguments passed to or from other methods}

\item{m}{number of vli objects being initialized; numeric}
}
\description{
vli is a S3 class that allows to store and operate with arbitrarily large integers. Each object of class vli has 3 attributes (\code{sign}, \code{length} and \code{value}) that can be accessed as shown in the examples. The (absolute) value of the number is stored in a numeric vector to avoid truncation.
}
\details{
In \code{as.vli(n)}, if \code{n} is numeric, it must be a 32 bits integer to avoid the loss of precision. The idea is to use numeric objects only for small numbers. In other case, character objects are prefered.
The function \code{as.integer(x)}, where \code{x} a vli object, only works when the absolute value of \code{x} is up to 2.147.483.648 (32 bits). In other case it returns an error.
The function \code{asnumeric(x)} could cause loss of precision if the value of \code{x} is big.
The function \code{vli(m)} initialize a list of \code{m} objects of class vli.
Punctuation signs are ignored in the creation of vli objects (see the last example).
}
\examples{
## Creating a new vli object
x <- as.vli("-89027148538375418689123052")

## Printing a vli object
print(x)

## Testing the class
is.vli(x)

## Coercing into a character object
as.character(x)

## Accessing to the attributes of the vli object
x$sign
x$value
x$length

## Punctuation signs are ignored
as.vli("2345.25")
}
\author{
Javier Leiva Cuadrado
}
