Switch_edges <- function(j) {
  # Keeps track of the number of the random network that is generated while the program is running in  # the out log file and calls the function (serves as a counter). It also calls Sub_switch_edges.
  # Ultimate goal is to randomize a network with preserving its node in- and out-degrees
  # Args:
  #   j: an integer indicating the number of randomized networks that we need to generate
  # Returns:
  #   a graph object representing the rewired network that is generated by calling the
  #   Sub_switch_edges function.


  vgraph        <- get("vgraph", parent.frame())
  swaping_no    <- get("swaping_no", parent.frame())
  edges_no      <- get("edges_no", parent.frame())
  from          <- get("from", parent.frame())
  to            <- get("to", parent.frame())
  from_to       <- get("from_to", parent.frame())
  viteration_no <- get("viteration_no", parent.frame())
  log_name      <- get("log_name", parent.frame())

  if ( j == 1 ) {
    msg <- sprintf(paste0(as.character(Sys.time()), ": Randomizing network %d of %d"), j, viteration_no)
    write(msg, file=log_name, append=FALSE)
  }
  if ( j %% 10 == 0 ) {
    msg <- sprintf(paste0(as.character(Sys.time()), ": Randomizing network %d of %d"), j, viteration_no)
    write(msg, file=log_name, append=TRUE)
  }

  return(Sub_switch_edges(j, vgraph, swaping_no, edges_no, from, to, from_to))
}
