% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/matrixplot.R
\name{matrixplot}
\alias{TKRmatrixplot}
\alias{iimagMiss}
\alias{matrixplot}
\title{Matrix plot}
\usage{
matrixplot(x, delimiter = NULL, sortby = NULL, col = c("red", "orange"),
  gamma = 2.2, fixup = TRUE, xlim = NULL, ylim = NULL, main = NULL,
  sub = NULL, xlab = NULL, ylab = NULL, axes = TRUE, labels = axes,
  xpd = NULL, interactive = TRUE, ...)
}
\arguments{
\item{x}{a matrix or \code{data.frame}.}

\item{delimiter}{a character-vector to distinguish between variables and
imputation-indices for imputed variables (therefore, \code{x} needs to have
\code{\link{colnames}}). If given, it is used to determine the corresponding
imputation-index for any imputed variable (a logical-vector indicating which
values of the variable have been imputed). If such imputation-indices are
found, they are used for highlighting and the colors are adjusted according
to the given colors for imputed variables (see \code{col}).}

\item{sortby}{a numeric or character value specifying the variable to sort
the data matrix by, or \code{NULL} to plot without sorting.}

\item{col}{the colors to be used in the plot.  RGB colors may be specified
as character strings or as objects of class "\code{\link[colorspace]{RGB}}".
HCL colors need to be specified as objects of class
"\code{\link[colorspace]{polarLUV}}".  If only one color is supplied, it is
used for missing and imputed data and a greyscale is used for available
data. If two colors are supplied, the first is used for missing and the
second for imputed data and a greyscale for available data.  If three colors
are supplied, the first is used as end color for the available data, while
the start color is taken to be transparent for RGB or white for HCL.
Missing/imputed data is visualized by the second/third color in this case.
If four colors are supplied, the first is used as start color and the second
as end color for the available data, while the third/fourth color is used
for missing/imputed data.}

\item{gamma}{numeric; the display \emph{gamma} value (see
\code{\link[colorspace]{hex}}).}

\item{fixup}{a logical indicating whether the colors should be corrected to
valid RGB values (see \code{\link[colorspace]{hex}}).}

\item{xlim, ylim}{axis limits.}

\item{main, sub}{main and sub title.}

\item{xlab, ylab}{axis labels.}

\item{axes}{a logical indicating whether axes should be drawn on the plot.}

\item{labels}{either a logical indicating whether labels should be plotted
below each column, or a character vector giving the labels.}

\item{xpd}{a logical indicating whether the rectangles should be allowed to
go outside the plot region.  If \code{NULL}, it defaults to \code{TRUE}
unless axis limits are specified.}

\item{interactive}{a logical indicating whether a variable to be used for
sorting can be selected interactively (see \sQuote{Details}).}

\item{\dots}{for \code{matrixplot} and \code{iimagMiss}, further graphical
parameters to be passed to \code{\link[graphics]{plot.window}},
\code{\link[graphics]{title}} and \code{\link[graphics]{axis}}.  For
\code{TKRmatrixplot}, further arguments to be passed to \code{matrixplot}.}
}
\description{
Create a matrix plot, in which all cells of a data matrix are visualized by
rectangles.  Available data is coded according to a continuous color scheme,
while missing/imputed data is visualized by a clearly distinguishable color.
}
\details{
In a \emph{matrix plot}, all cells of a data matrix are visualized by
rectangles.  Available data is coded according to a continuous color scheme.
To compute the colors via interpolation, the variables are first scaled to
the interval \eqn{$[0,1]$}{[0,1]}. Missing/imputed values can then be
visualized by a clearly distinguishable color. It is thereby possible to use
colors in the \emph{HCL} or \emph{RGB} color space. A simple way of
visualizing the magnitude of the available data is to apply a greyscale,
which has the advantage that missing/imputed values can easily be
distinguished by using a color such as red/orange.  Note that \code{-Inf}
and \code{Inf} are always assigned the begin and end color, respectively, of
the continuous color scheme.

Additionally, the observations can be sorted by the magnitude of a selected
variable.  If \code{interactive} is \code{TRUE}, clicking in a column
redraws the plot with observations sorted by the corresponding variable.
Clicking anywhere outside the plot region quits the interactive session.
}
\note{
This is a much more powerful extension to the function \code{imagmiss}
in the former CRAN package \code{dprep}.

\code{iimagMiss} is deprecated and may be omitted in future versions of
\code{VIM}.  Use \code{matrixplot} instead.
}
\examples{

data(sleep, package = "VIM")
## for missing values
x <- sleep[, -(8:10)]
x[,c(1,2,4,6,7)] <- log10(x[,c(1,2,4,6,7)])
matrixplot(x, sortby = "BrainWgt")

## for imputed values
x_imp <- kNN(sleep[, -(8:10)])
x_imp[,c(1,2,4,6,7)] <- log10(x_imp[,c(1,2,4,6,7)])
matrixplot(x_imp, delimiter = "_imp", sortby = "BrainWgt")

}
\author{
Andreas Alfons, Matthias Templ, modifications by Bernd Prantner
}
\references{
M. Templ, A. Alfons, P. Filzmoser (2012) Exploring incomplete
data using visualization tools.  \emph{Journal of Advances in Data Analysis
and Classification}, Online first. DOI: 10.1007/s11634-011-0102-y.
}
\keyword{hplot}

