% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GetPriors.R
\name{GetPriors}
\alias{GetPriors}
\title{Returns prior dose-specific means.}
\usage{
GetPriors(PROBST, PROBSE, Var, HypVar, tau, B)
}
\arguments{
\item{PROBST}{Elicited prior toxicity probability at each dose.}

\item{PROBSE}{Elicted prior efficacy probability at each dose.}

\item{Var}{Latent parameter variance for normal probability of efficacy and toxicity.}

\item{HypVar}{Hypervariance on dose specific mean efficacy and toxicity parameters.}

\item{tau}{Frailty variance parameter.}

\item{B}{Number of prior samples to draw for calculating ESS. Suggested values of ten thousand.}
}
\value{
A list contianing the vector of dose-specific efficacy probability prior mean parameters and the vector of dose-specific toxicity probability prior mean parameters.
}
\description{
Uses elicited efficacy and toxicity dose-specific parameters along with latent prior variance, dose-specific mean hypervariance and frailty variance to determine dose-specific prior means for efficacy and toxicity and prints the prior effective sample size associated with the specified prior parameters.
}
\examples{
library(mvtnorm)
PROBST=c(.05,.10,.15,.20,.30)
PROBSE=c(.2,.4,.6,.65,.7)
Var=1
HypVar=36
tau=1
B=100
Z=GetPriors(PROBST,PROBSE,Var,HypVar,tau,B)
}
