% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class-02-UncertainPoints.R
\docType{class}
\name{UncertainPoints-class}
\alias{UncertainPoints-class}
\title{S4 class Representing a UncertainPoints}
\description{
Definition of S4 class for output data from functions of package 
\code{UncerIn2}, which are building uncertainty models over input data. 
Also defines input data format into the interpolation function of package 
\code{UncerIn2}. Where \code{x, y} should represent coordinates and \code{uncertaintyLower, 
modalValue, uncertaintyUpper} the variables of uncertainty model.
}
\section{Slots}{

 \describe{
   \item{\code{x}:}{Input numeric data (number specyfing the x coordinate).}
   \item{\code{y}:}{Input numeric data (number specyfing the y coordinate).}
   \item{\code{uncertaintyLower}:}{Defined model values of uncertaintyLower - the bottom calculated part.}
   \item{\code{modalValue}:}{Defined model values of modalValue - the mean values.}
   \item{\code{uncertaintyUpper}:}{Defined model values of uncertaintyUpper - the upper calculated part.}
 }
}
\examples{
showClass("UncertainPoints")
}
\seealso{
\code{\link[UncerIn2]{uncertaintyInterpolation2-package}}

Other res: \code{\link{FuzzyInterpolation-class}},
  \code{\link{Points-class}},
  \code{\link{UncertainInterpolation-class}}
}

