% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SUMMARY.R
\name{summary.UPG.MNL}
\alias{summary.UPG.MNL}
\title{Estimation results and tables for UPG.MNL objects}
\usage{
\method{summary}{UPG.MNL}(
  object = NULL,
  ...,
  q = c(0.025, 0.975),
  groups = NULL,
  names = NULL,
  digits = 2,
  include = NULL,
  table = NULL,
  cap = NULL
)
}
\arguments{
\item{object}{an object of class \code{UPG.MNL}.}

\item{...}{other summary parameters.}

\item{q}{a numerical vector of length two providing the posterior quantiles to be extracted. Default are 0.025 and 0.975 quantiles.}

\item{groups}{a character vector indicating names for the groups, excluding the baseline. The group names must correspond to the ordering in the dependent variable used for estimation.}

\item{names}{a character vector indicating names for the variables used in the output.}

\item{digits}{number of digits to be included in output. Last digit will be rounded using \code{round}.}

\item{include}{can be used to summarize and tabulate only a subset of variables. Specify the columns of X that should be kept in the plot. See examples for further information.}

\item{table}{can be used to return a LaTeX table (\code{'latex'}), a Word table (\code{'pandoc'}) and HTML tables (\code{'html'}) via \code{knitr}. Include package "booktabs" in LaTeX preamble for LaTeX tables.}

\item{cap}{character vector that can be used to specify the table caption.}
}
\value{
Returns a \code{knitr_kable} object containing the summary table.
}
\description{
\code{summary} generates a summary of estimation results for \code{UPG.MNL} objects. Point estimates, estimated standard deviation as well as credible intervals for each variable are tabulated. In addition, an indicator quickly shows whether the credible interval includes zero or not. Moreover, LaTeX, HTML and pandoc tables can be quickly generated via \code{knitr}.
}
\examples{
\donttest{
# estimate a multinomial logit model using example data
library(UPG)
data(program)
y = program[,1]
X = program[,-1]
results.mnl = UPG(y = y, X = X, model = "mnl")

# basic summary of regression results
summary(results.mnl)

# generate a LaTeX table with subset of variables and custom names
summary(results.mnl,
        include=c(1,3),
        groups=c("Alpha","Beta"),
        names=c("V. kept 1", "V. kept 3"),
        table="latex")
}
}
\seealso{
\code{\link{plot.UPG.MNL}} to plot a \code{UPG.MNL} object.
\code{\link{predict.UPG.MNL}} to predict probabilities using a \code{UPG.MNL} object.
\code{\link{coef.UPG.MNL}} to extract coefficients from a \code{UPG.MNL} object.
}
\author{
Gregor Zens
}
