% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PRINT.R
\name{print.UPG.Probit}
\alias{print.UPG.Probit}
\title{Print information for UPG.Probit objects}
\usage{
\method{print}{UPG.Probit}(x, ...)
}
\arguments{
\item{x}{an object of class \code{UPG.Probit}.}

\item{...}{other print parameters.}
}
\description{
\code{print} provides some basic information about an \code{UPG.Probit} object.
}
\examples{
\donttest{
# estimate a probit model using example data
library(UPG)
data(lfp)
y = lfp[,1]
X = lfp[,-1]
results.probit = UPG(y = y, X = X, type = "probit", verbose=TRUE)
print(results.probit)
}
}
\seealso{
\code{\link{summary.UPG.Probit}} to summarize the estimates of a discrete choice model from an \code{UPG.Probit} object and create tables.
\code{\link{predict.UPG.Probit}} to predict probabilities from a discrete choice model from an \code{UPG.Probit} object.
\code{\link{plot.UPG.Probit}} to plot the results of a discrete choice model from an \code{UPG.Probit} object.
}
\author{
Gregor Zens
}
