% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/All.R
\name{WeightsUnLSkew}
\alias{WeightsUnLSkew}
\title{Site ungauged linear skewness (LSkew) weightings}
\usage{
WeightsUnLSkew(x)
}
\arguments{
\item{x}{pooling group derived with the Pool() function}
}
\value{
A data.frame with site references in the first column and associated weights in the second
}
\description{
Provides the ungauged LSkew weights for each site in a pooling group
}
\details{
Weighting method as according to Science Report: SC050050 - Improving the FEH statistical procedures for flood frequency estimation
}
\examples{
#Get some CDs, form an ungauged pooling group, and estimate ungauged LSkew
CDs.96001 <- GetCDs(96001)
Pool.96001 <- Pool(CDs.96001, exclude = 96001)
WeightsUnLSkew(Pool.96001)
}
\author{
Anthony Hammond
}
