% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vis_pancan_value.R
\name{vis_toil_TvsN_cancer}
\alias{vis_toil_TvsN_cancer}
\title{Visualize Gene TPM in Single Cancer Type (Tumor (TCGA) vs Normal (TCGA & GTEx))}
\usage{
vis_toil_TvsN_cancer(
  Gene = "TP53",
  Mode = c("Violinplot", "Dotplot"),
  data_type = "mRNA",
  Show.P.value = FALSE,
  Show.P.label = FALSE,
  Method = "wilcox.test",
  values = c("#DF2020", "#DDDF21"),
  TCGA.only = FALSE,
  Cancer = "ACC",
  opt_pancan = .opt_pancan
)
}
\arguments{
\item{Gene}{a molecular identifier (e.g., "TP53") or a formula specifying
genomic signature (\code{"TP53 + 2 * KRAS - 1.3 * PTEN"}).}

\item{Mode}{"Boxplot" or "Violinplot" to represent data}

\item{data_type}{choose gene profile type,
including "mRNA", "transcript", "protein", "mutation", "cnv", "methylation", "miRNA".}

\item{Show.P.value}{\code{TRUE} or \code{FALSE} whether to count P value}

\item{Show.P.label}{\code{TRUE} or \code{FALSE} present p value with number or label \code{*}, \verb{**}, \verb{***} and \verb{****}}

\item{Method}{default method is wilcox.test}

\item{values}{the color to fill tumor or normal}

\item{TCGA.only}{include samples only from TCGA dataset}

\item{Cancer}{select cancer cohort(s).}

\item{opt_pancan}{specify one dataset for some molercular profiles}
}
\value{
a \code{ggplot} object.
}
\description{
Visualize Gene TPM in Single Cancer Type (Tumor (TCGA) vs Normal (TCGA & GTEx))
}
