% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ezcor.R
\name{ezcor_batch}
\alias{ezcor_batch}
\title{Run correlation between two variables in a batch mode and support group by a variable}
\usage{
ezcor_batch(
  data,
  var1,
  var2,
  split = FALSE,
  split_var = NULL,
  cor_method = "pearson",
  adjust_method = "none",
  use = "complete",
  sig_label = TRUE,
  parallel = FALSE,
  verbose = FALSE
)
}
\arguments{
\item{data}{a \code{data.frame} containing variables}

\item{var1}{a character, the first variable in correlation}

\item{var2}{a character, the second variable in correlation}

\item{split}{whether perform correlation grouped by a variable, default is 'FALSE'}

\item{split_var}{a \code{character}, the group variable}

\item{cor_method}{method="pearson" is the default value. The alternatives to be passed to cor are "spearman" and "kendall"}

\item{adjust_method}{What adjustment for multiple tests should be used? ("holm", "hochberg", "hommel", "bonferroni", "BH", "BY", "fdr", "none")}

\item{use}{use="pairwise" will do pairwise deletion of cases. use="complete" will select just complete cases}

\item{sig_label}{whether add symbal of significance. P < 0.001,\verb{***}; P < 0.01,\verb{**}; P < 0.05,\code{*}; P >=0.05,""}

\item{parallel}{if \code{TRUE}, do parallel computation by \strong{furrr} package.}

\item{verbose}{if \code{TRUE}, print extra info.}
}
\value{
a \code{data.frame}
}
\description{
Run correlation between two variables in a batch mode and support group by a variable
}
\author{
Yi Xiong, Shixiang Wang
}
