% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/IMU_TwoRegressionProcessing_Helper_Functions.R
\name{imu_verify}
\alias{imu_verify}
\title{Identify IMU files that can be ignored when Algorithm = 1}
\usage{
imu_verify(IMU, Algorithm, IMU_ignore_A1)
}
\arguments{
\item{IMU}{A character scalar giving path to IMU data file}

\item{Algorithm}{A numeric vector giving the algorithm(s) to apply to the data from the primary accelerometer and (if applicable) IMU}

\item{IMU_ignore_A1}{A logical scalar. If Algorithm = 1, should IMU files be ignored?}
}
\description{
Identify IMU files that can be ignored when Algorithm = 1
}
\examples{
\dontrun{
imu_file <-
    system.file("extdata",
        "TestID_LeftWrist_IMU.csv",
        package = "TwoRegression")

TwoRegression:::imu_verify(imu_file, 1, TRUE)
TwoRegression:::imu_verify(imu_file, 1, FALSE)
}

}
\keyword{internal}
