\name{boxdiff.plot}
\alias{boxdiff.plot}
\title{Returns a \code{ggplot2} box plot of the differences.}
\usage{
  boxdiff.plot(tmatch, out, plot.mean = TRUE,
    ordering = attr(tmatch, "match.order"), ci.width = 0.5)
}
\arguments{
  \item{tmatch}{the results from \code{\link{trimatch}}.}

  \item{out}{a vector of the outcome measure of interest.}

  \item{plot.mean}{logical indicating whether the means
  should be plotted.}

  \item{ordering}{specify the order for doing the paired
  analysis, that is analysis will be conducted as:
  \code{ordering[1] - ordering[2]}, \code{ordering[1] -
  ordering[3]}, and \code{ordering[2] - ordering[3]}.}

  \item{ci.width}{the width for the confidence intervals.}
}
\value{
  a \code{ggplot2} boxplot of the differences.
}
\description{
  A boxplot of differences between each pair of treatments.
}

