% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RadiationFunctions.R
\name{direct_solar_radiation}
\alias{direct_solar_radiation}
\title{Direct Solar Radiation}
\usage{
direct_solar_radiation(lat, doy, elev, t, t0, method = "Campbell 1977")
}
\arguments{
\item{lat}{\code{numeric} latitude (degrees).}

\item{doy}{\code{numeric} day of year (1-366).}

\item{elev}{\code{numeric} elevation (m).}

\item{t}{\code{numeric} local time (decimal hours).}

\item{t0}{\code{numeric} time of local noon (decimal hours), can be estimated using \code{\link{solar_noon}}.}

\item{method}{\code{character} method for estimating direct solar radiation, options: \code{"Campbell 1977"} (default), \code{"Gates 1962"}.}
}
\value{
\code{numeric} direct solar radiation (\ifelse{html}{\out{W/m<sup>2</sup>}}{\eqn{W/m^2}{ASCII}}).
}
\description{
The function estimates direct solar radiation (\ifelse{html}{\out{W/m<sup>2</sup>}}{\eqn{W/m^2}{ASCII}}) based on latitude, day of year, elevation, and time. The function uses two methods \insertCite{McCullough1971,Campbell1998}{TrenchR} compiled in \insertCite{Tracy1983;textual}{TrenchR}.
}
\examples{
  direct_solar_radiation(lat    = 47.61, 
                         doy    = 112, 
                         elev   = 1500, 
                         t      = 9, 
                         t0     = 12, 
                         method = "Campbell 1977")

}
\references{
\insertAllCited{}
}
\seealso{
Other microclimate functions: 
\code{\link{air_temp_profile_neutral}()},
\code{\link{air_temp_profile_segment}()},
\code{\link{air_temp_profile}()},
\code{\link{degree_days}()},
\code{\link{diurnal_radiation_variation}()},
\code{\link{diurnal_temp_variation_sineexp}()},
\code{\link{diurnal_temp_variation_sinesqrt}()},
\code{\link{diurnal_temp_variation_sine}()},
\code{\link{monthly_solar_radiation}()},
\code{\link{partition_solar_radiation}()},
\code{\link{proportion_diffuse_solar_radiation}()},
\code{\link{solar_radiation}()},
\code{\link{surface_roughness}()},
\code{\link{wind_speed_profile_neutral}()},
\code{\link{wind_speed_profile_segment}()}
}
\concept{microclimate functions}
