% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R, R/tree_shape.R
\docType{data}
\name{unrootedKeys}
\alias{unrootedKeys}
\alias{TreeShape}
\alias{RootedTreeShape}
\alias{RootedTreeWithShape}
\alias{UnrootedTreeWithShape}
\alias{UnrootedTreeWithKey}
\alias{UnrootedTreeShape}
\alias{UnrootedTreeKey}
\alias{.UnrootedKeys}
\alias{UnrootedKeys}
\alias{NUnrootedShapes}
\alias{NRootedShapes}
\title{Integer representing shape of a tree}
\format{
\code{unrootedKeys} is a list of length 22; each
entry is a vector of integers corresponding to they keys (not shape numbers)
of the different unrooted tree shapes with \code{nTip} leaves.
}
\usage{
unrootedKeys

RootedTreeShape(tree)

RootedTreeWithShape(shape, nTip, tipLabels)

UnrootedTreeWithShape(shape, nTip, tipLabels = character(nTip))

UnrootedTreeWithKey(key, nTip, tipLabels = character(nTip))

UnrootedTreeShape(tree)

UnrootedTreeKey(tree, asInteger = FALSE)

.UnrootedKeys(nTip)

UnrootedKeys(..., envir = parent.frame())

NUnrootedShapes(nTip)

NRootedShapes(nTip)
}
\arguments{
\item{tree}{A tree of class \code{\link[ape:read.tree]{phylo}}.}

\item{shape}{Integer specifying shape of tree, perhaps generated by
\code{TreeShape()}.}

\item{nTip}{Integer specifying number of tips.}

\item{tipLabels}{Character vector listing the labels assigned to each tip
in a tree, perhaps obtained using \code{\link[=TipLabels]{TipLabels()}}.}

\item{key}{Integer specifying the \emph{key} (not number) of an unrooted tree.}

\item{asInteger}{Logical specifying whether to coerce the return value to
mode \code{integer}: only possible for values < 2^31.
If \code{FALSE}, values will have class \code{integer64}.}

\item{\dots}{Value of \code{nTip}, to pass to memoized \code{.UnrootedKeys}.}

\item{envir}{Unused; passed to \code{\link[R.cache]{addMemoization}()}.}
}
\value{
\code{TreeShape()} returns an integer specifying the shape of a tree,
ignoring tip labels.

\code{RootedTreeWithShape()} returns a tree of class \code{phylo}
corresponding to the shape provided.  Tips are unlabelled.

\code{UnrootedTreeWithShape()} returns a tree of class \code{phylo}
corresponding to the shape provided.  Tips are unlabelled.

\code{UnrootedTreeWithKey()} returns a tree of class \code{phylo} corresponding
to the key provided.  Tips are unlabelled.

\code{UnrootedKeys()} returns a vector of integers corresponding to the
keys (not shape numbers) of unrooted tree shapes with \code{nTip} tips.
It is a wrapper to \code{.UnrootedKeys()}, with memoization, meaning that results
once calculated are cached and need not be calculated on future calls to
the function.

\code{NUnrootedShapes()} returns an object of class \code{integer64} specifying
the number of unique unrooted tree shapes with \code{nTip} (< 61) tips.

\code{NRootedShapes()} returns an object of class \code{integer64} specifying
the number of unique rooted tree shapes with \code{nTip} (< 56) leaves.
}
\description{
Returns an integer that uniquely represents the shape of an \emph{n}-tip
binary tree, ignoring tip labels.
}
\details{
Rooted trees are numbered working up from the root.

The root node divides \emph{n} tips into two subtrees.  The smaller subtree
may contain $a = 1, 2, ..., n/2$ tips, leaving $b = n - a$ tips in
These options are worked through in turn.

For the first shape of the smaller subtree, work through each possible shape
for the larger subtree.  Then, move to the next shape of the smaller subtree,
and work through each possible shape of the larger subtree.

Stop when the desired topology is encountered.

Unrooted trees are numbered less elegantly.  Each cherry (i.e. node
subtending a pair of tips) is treated in turn.  The subtended tips are
removed, and the node treated as the root of a rooted tree.  The number of
this rooted tree is then calculated.  The tree is assigned a \emph{key}
corresponding to the lowest such value.  The keys of all unrooted tree shapes
on \emph{n} tips are ranked, and the unrooted tree shape is assigned a \emph{number}
based on the rank order of its key among all possible keys, counting from
zero.

If \code{UnrootedTreeShape()} or \code{UnrootedTreeKey()} is passed a rooted tree,
the position of the root will be ignored.

The number of unlabelled binary rooted trees corresponds to the
\href{https://oeis.org/A001190}{Wedderburn-Etherington numbers}.
}
\examples{
RootedTreeShape(PectinateTree(8))
plot(RootedTreeWithShape(0, nTip = 8L))

NRootedShapes(8L)
# Shapes are numbered from 0 to NRootedShapes(n) - 1.  The maximum shape is:
RootedTreeShape(BalancedTree(8))

# Unique shapes of unrooted trees:
NUnrootedShapes(8L)

# Keys of these trees:
UnrootedKeys(8L)

# A tree may be represented by multiple keys.
# For a one-to-one correspondence, use a number instead:
unrootedShapes8 <- as.integer(NUnrootedShapes(8L))
allShapes <- lapply(seq_len(unrootedShapes8) - 1L,
                    UnrootedTreeWithShape, 8L)
plot(allShapes[[1]])
sapply(allShapes, UnrootedTreeShape)
sapply(allShapes, UnrootedTreeKey, asInteger = TRUE) # Key >= number

# If numbers larger than 2>31 are required, sapply needs a little help
# with 64-bit integers:
structure(sapply(allShapes, UnrootedTreeKey), class = "integer64")


}
\seealso{
Unique number for a labelled tree: \code{\link[=TreeNumber]{TreeNumber()}}
}
\author{
\href{https://orcid.org/0000-0001-5660-1727}{Martin R. Smith}
(\href{mailto:martin.smith@durham.ac.uk}{martin.smith@durham.ac.uk})
}
\keyword{datasets}
\keyword{internal}
