% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tree_ancestors.R
\name{AncestorEdge}
\alias{AncestorEdge}
\title{Ancestral edge}
\usage{
AncestorEdge(edge, parent, child)
}
\arguments{
\item{edge}{Number of an edge}

\item{parent}{Integer vector corresponding to the first column of the edge
matrix of a tree of class \code{\link{phylo}}, i.e. \code{tree[["edge"]][, 1]}}

\item{child}{Integer vector corresponding to the second column of the edge
matrix of a tree of class \code{\link{phylo}}, i.e. \code{tree[["edge"]][, 2]}.}
}
\value{
\code{AncestorEdge} returns a logical vector identifying whether each edge
is the immediate ancestor of the given edge.
}
\description{
Ancestral edge
}
\examples{
tree <- BalancedTree(6)
parent <- tree$edge[, 1]
child <- tree$edge[, 2]
plot(tree)
ape::edgelabels()
AncestorEdge(5, parent, child)
which(AncestorEdge(5, parent, child))

}
\seealso{
Other tree navigation: 
\code{\link{CladeSizes}()},
\code{\link{DescendantEdges}()},
\code{\link{EdgeAncestry}()},
\code{\link{EdgeDistances}()},
\code{\link{ListAncestors}()},
\code{\link{MRCA}()},
\code{\link{MatchEdges}()},
\code{\link{NDescendants}()},
\code{\link{NodeDepth}()},
\code{\link{NodeNumbers}()},
\code{\link{NodeOrder}()},
\code{\link{RootNode}()}
}
\concept{tree navigation}
\keyword{internal}
