% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tree_rearrangement.R
\name{DropTip}
\alias{DropTip}
\title{Drop tips from tree}
\usage{
DropTip(tree, tip)
}
\arguments{
\item{tree}{A tree of class \code{\link[ape:read.tree]{phylo}}.}

\item{tip}{Character vector specifying labels of leaves in tree to be dropped,
or integer vector specifying the indices of leaves to be dropped.
Specifying the index of an internal node will drop all descendants of that
node.}
}
\value{
\code{DropTip()} returns a tree of class \code{phylo}, in \link{Preorder}, with the
requested leaves removed.
}
\description{
\code{DropTip()} removes specified tips from a phylogenetic tree, collapsing
incident branches.
}
\details{
This function is more robust than \code{\link[ape:drop.tip]{ape::drop.tip()}} as it does not
require any particular internal node numbering schema.  It is not presently
as fast, though it is ripe for optimization; if you are finding this
function is a rate-limiting step, please get in touch and I'll prioritise
writing a faster implementation.
}
\examples{
tree <- BalancedTree(8)
plot(tree)
plot(DropTip(tree, c('t4', 't5')))

}
\seealso{
Other tree manipulation: 
\code{\link{AddTip}()},
\code{\link{CollapseNode}()},
\code{\link{ConsensusWithout}()},
\code{\link{EnforceOutgroup}()},
\code{\link{LeafLabelInterchange}()},
\code{\link{MakeTreeBinary}()},
\code{\link{RenumberTips}()},
\code{\link{RenumberTree}()},
\code{\link{Renumber}()},
\code{\link{RootTree}()},
\code{\link{SingleTaxonTree}()},
\code{\link{SortTree}()},
\code{\link{Subtree}()}
}
\author{
Martin R. Smith (\href{mailto:martin.smith@durham.ac.uk}{martin.smith@durham.ac.uk})
}
\concept{tree manipulation}
