% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Information.R
\name{SplitInformation}
\alias{SplitInformation}
\alias{MultiSplitInformation}
\title{Information content of a split}
\usage{
SplitInformation(A, B)

MultiSplitInformation(partitionSizes)
}
\arguments{
\item{A}{Number of taxa in each partition.}

\item{B}{Number of taxa in each partition.}

\item{partitionSizes}{Integer vector specifying the number of taxa in each
partition of a multi-partition split.}
}
\value{
Information content of the split, in bits.
}
\description{
\code{SplitInformation} calculates the information content of a split, based on
the entropy of the subset of trees consistent with the split; a split that
is consistent with a smaller number of trees will have a higher information
content.
}
\section{Functions}{
\itemize{
\item \code{MultiSplitInformation}: Information content of a multi-partition split.
}}

\examples{
  # Eight tips can be split evenly:
  SplitInformation (4, 4)

  # or unevenly, which is less informative:
  SplitInformation (2, 6)

}
\seealso{
Other split information functions: 
\code{\link{CharacterInformation}()},
\code{\link{TreesMatchingSplit}()},
\code{\link{UnrootedTreesMatchingSplit}()}
}
\author{
Martin R. Smith (\href{mailto:martin.smith@durham.ac.uk}{martin.smith@durham.ac.uk})
}
\concept{split information functions}
