% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tree_generation.R
\name{PectinateTree}
\alias{PectinateTree}
\title{Generate a Pectinate Tree}
\usage{
PectinateTree(tips)
}
\arguments{
\item{tips}{An integer specifying the number of tips, or a character vector
naming the tips, or any other object from which tip labels can be extracted
with function \code{TipLabels}.}
}
\value{
\code{PectinateTree} and \code{BalancedTree} each return a binary tree of
class \code{phylo} of the specified shape.
}
\description{
Generates a pectinate (caterpillar) tree with the specified tip labels.
}
\examples{
plot(PectinateTree(LETTERS[1:10]))

}
\seealso{
Other tree generation functions: 
\code{\link{BalancedTree}()},
\code{\link{NJTree}()},
\code{\link{RandomTree}()},
\code{\link{SingleTaxonTree}()},
\code{\link{TreeNumber}}
}
\author{
Martin R. Smith (\href{mailto:martin.smith@durham.ac.uk}{martin.smith@durham.ac.uk})
}
\concept{tree generation functions}
