% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AdditionTree.R
\name{AdditionTree}
\alias{AdditionTree}
\title{Addition tree}
\usage{
AdditionTree(dataset, concavity = Inf, constraint, sequence)
}
\arguments{
\item{dataset}{A phylogenetic data matrix of class \code{\link[phangorn]{phyDat}},
whose names correspond to the labels of any accompanying tree.}

\item{concavity}{Numeric specifying concavity constant for implied step
weighting; set as \code{Inf} for equal step weights (which is a bad idea; see
\insertCite{Smith2019;textual}{TreeSearch}).}

\item{constraint}{An object of class \code{phyDat}; returned trees will be
perfectly compatible with each character in \code{constraint}.
See \code{\link[=ImposeConstraint]{ImposeConstraint()}} and
\href{https://ms609.github.io/TreeSearch/articles/inapplicable.html}{vignette}
for further examples.}

\item{sequence}{Character or numeric vector listing sequence in which to add
taxa. Randomized if not provided.}
}
\value{
\code{AdditionTree()} returns a tree of class \code{phylo}, rooted on
\code{sequence[1]}.
}
\description{
Generates a starting tree by adding each taxon in turn to the most
parsimonious location.
}
\examples{
data('Lobo', package = 'TreeTools')
AdditionTree(Lobo.phy, concavity = 10)
}
\seealso{
Other tree generation functions: 
\code{\link{RandomMorphyTree}()}
}
\author{
\href{https://smithlabdurham.github.io/}{Martin R. Smith}
(\href{mailto:martin.smith@durham.ac.uk}{martin.smith@durham.ac.uk})
}
\concept{tree generation functions}
