% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mpl_morphy_objects.R
\name{SetMorphyWeights}
\alias{SetMorphyWeights}
\title{Set the character weightings associated with a Morphy object}
\usage{
SetMorphyWeights(weight, morphyObj, checkInput = TRUE)
}
\arguments{
\item{weight}{A vector listing the new weights to be applied to each character}

\item{morphyObj}{Object of class \code{morphy}, perhaps created with
\code{\link[=PhyDat2Morphy]{PhyDat2Morphy()}}.}

\item{checkInput}{Whether to sanity-check input data before applying.
Defaults to TRUE to protect the user from crashes.}
}
\value{
\code{SetMorphyWeights()} returns the Morphy error code generated when
applying \code{tipData}.
}
\description{
Set the character weightings associated with a Morphy object
}
\seealso{
Other Morphy API functions: 
\code{\link{MorphyErrorCheck}()},
\code{\link{MorphyWeights}()},
\code{\link{PhyDat2Morphy}()},
\code{\link{SingleCharMorphy}()},
\code{\link{UnloadMorphy}()},
\code{\link{mpl_apply_tipdata}()},
\code{\link{mpl_attach_rawdata}()},
\code{\link{mpl_attach_symbols}()},
\code{\link{mpl_delete_Morphy}()},
\code{\link{mpl_delete_rawdata}()},
\code{\link{mpl_first_down_recon}()},
\code{\link{mpl_first_up_recon}()},
\code{\link{mpl_get_charac_weight}()},
\code{\link{mpl_get_num_charac}()},
\code{\link{mpl_get_num_internal_nodes}()},
\code{\link{mpl_get_numtaxa}()},
\code{\link{mpl_get_symbols}()},
\code{\link{mpl_init_Morphy}()},
\code{\link{mpl_new_Morphy}()},
\code{\link{mpl_second_down_recon}()},
\code{\link{mpl_second_up_recon}()},
\code{\link{mpl_set_charac_weight}()},
\code{\link{mpl_set_num_internal_nodes}()},
\code{\link{mpl_set_parsim_t}()},
\code{\link{mpl_translate_error}()},
\code{\link{mpl_update_lower_root}()},
\code{\link{mpl_update_tip}()},
\code{\link{summary.morphyPtr}()}
}
\author{
Martin R. Smith
}
\concept{Morphy API functions}
