% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tree_rearrangement.R
\name{RearrangeEdges}
\alias{RearrangeEdges}
\title{Rearrange edges of a phylogenetic tree}
\usage{
RearrangeEdges(parent, child, dataset, TreeScorer = MorphyLength,
  EdgeSwapper, scoreToBeat = TreeScorer(parent, child, dataset, ...),
  iter = "?", hits = 0L, verbosity = 0L, ...)
}
\arguments{
\item{parent}{the first column of the edge matrix of a tree of class \code{\link{phylo}}, i.e. tree$edge[, 1]}

\item{child}{the second column of the edge matrix of a tree of class \code{\link{phylo}}, i.e. tree$edge[, 2]}

\item{dataset}{Third argument to pass to \code{TreeScorer}.}

\item{TreeScorer}{function to score a given tree.
The function will be passed three parameters, corresponding to the 
`parent` and `child` entries of a tree's edge list, and a dataset.}

\item{EdgeSwapper}{a function that rearranges a parent and child vector, 
and returns a list with modified vectors; for example
\code{\link{SPRSwap}}.}

\item{scoreToBeat}{Double giving score of input tree.}

\item{iter}{iteration number of calling function, for reporting to user only.}

\item{hits}{Integer giving number of times the input tree has already been hit.}

\item{verbosity}{Level of detail to display in console: larger numbers provide
more verbose feedback to the user.}

\item{\dots}{further arguments to pass to \code{TreeScorer} function (e.g. \code{\link{TipsAreColumns}}, \code{dataset})}
}
\value{
This function returns a list with two to four elements, corresponding to a binary tree:
        - 1. Integer vector listing the parent node of each edge;
        - 2. Integer vector listing the child node of each edge;
        - 3. Score of the tree;
        - 4. Number of times that score has been hit.
}
\description{
Rearranges a matrix that corresponds to the edges of a phylogenetic tree,
returning the score of the new tree.  Will generally be called from
within a tree search function.
}
\details{
\code{RearrangeTree} performs one tree rearrangement of a
 specified type, and returns the score of the tree (with the given dataset).
 It also reports the number of times that this score was hit in the 
 current function call.
}
\examples{
data('Lobo')
random.tree <- RandomTree(Lobo.phy)
edge <- random.tree$edge
parent <- edge[, 1]
child <- edge[, 2]
dataset <- PhyDat2Morphy(Lobo.phy)
RearrangeEdges(parent, child, dataset, EdgeSwapper=RootedNNISwap)

}
\author{
Martin R. Smith
}
