% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{treeMap}
\alias{treeMap}
\title{Map tree occurrences from TLS data}
\usage{
treeMap(las, method = map.hough())
}
\arguments{
\item{las}{\code{LAS} object.}

\item{method}{tree mapping algorithm - currently available: \code{\link{map.hough}}.}
}
\value{
\code{LAS} object with \emph{tree_map} signature.
}
\description{
Estimates tree occurrence regions from a \strong{normalized} point cloud.
}
\section{Output}{

The output is a \code{LAS} object with extra fields in the \code{data} slot. For more details on the output fields checkout \code{\link{map.hough}}'s help page.
}

\examples{
file = system.file("extdata", "model_boles.laz", package="TreeLS")
tls = readTLS(file)
plot(tls)

## build a 3D map of tree occurrences
map = treeMap(tls)
plot(map, color='Radii')

## get a 2D representation of the tree map
xymap = treePositions(map)
head(xymap)
}
