% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EnrichmentSpiralize.R
\name{adjust_color_tone}
\alias{adjust_color_tone}
\title{Adjust Color Tone by Modifying Saturation and Luminance}
\usage{
adjust_color_tone(color, saturation_scale, luminance_scale)
}
\arguments{
\item{color}{A color in hexadecimal format (e.g., "#FF0000") or a valid R color name.}

\item{saturation_scale}{Numeric, the scaling factor for saturation (values < 1 decrease saturation, values > 1 increase saturation).}

\item{luminance_scale}{Numeric, the scaling factor for luminance (values < 1 darken the color, values > 1 lighten the color).}
}
\value{
Returns a color in hexadecimal format adjusted according to the provided scales.
}
\description{
This function adjusts the saturation and luminance of a given color. It works by converting
the color from RGB to Luv color space, applying the scaling factors to the saturation and luminance,
and then converting it back to RGB.
}
\examples{
  adjusted_color <- adjust_color_tone("#FF0000", saturation_scale = 0.8, luminance_scale = 1.2)
  print(adjusted_color)

}
