% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/10-helpers-spatial.R
\name{calculate_manhattan_distance}
\alias{calculate_manhattan_distance}
\title{Calculate Manhattan distance between coordinates}
\usage{
calculate_manhattan_distance(lon1, lat1, lon2, lat2, unit)
}
\arguments{
\item{lon1}{Origin longitude.}

\item{lat1}{Origin latitude.}

\item{lon2}{Destination longitude vector.}

\item{lat2}{Destination latitude vector.}

\item{unit}{Distance unit: "nm" or "km".}
}
\value{
List with minimum distance and corresponding index.
}
\description{
Internal function to calculate Manhattan distance (L1 norm) between coordinates,
adapted for geographic coordinate systems.
}
\details{
The Manhattan distance calculates the sum of absolute differences between coordinates,
adapted for geographic coordinates using spherical projection approximations.
This implementation accounts for Earth's curvature by applying latitude corrections
to longitude differences.
}
\note{
This implementation adapts the standard Manhattan distance metric for geographic
coordinate systems by incorporating Earth's radius and latitude corrections.
}
\keyword{internal}
