% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/autoplot-four-graphs.R
\name{tidy_four_autoplot}
\alias{tidy_four_autoplot}
\title{Automatic Plot of Density Data}
\usage{
tidy_four_autoplot(
  .data,
  .line_size = 0.5,
  .geom_point = FALSE,
  .point_size = 1,
  .geom_rug = FALSE,
  .geom_smooth = FALSE,
  .geom_jitter = FALSE,
  .interactive = FALSE
)
}
\arguments{
\item{.data}{The data passed in from a tidy_\code{distribution} function like
\code{tidy_normal()}}

\item{.line_size}{The size param ggplot}

\item{.geom_point}{A Boolean value of TREU/FALSE, FALSE is the default. TRUE
will return a plot with \code{ggplot2::ggeom_point()}}

\item{.point_size}{The point size param for ggplot}

\item{.geom_rug}{A Boolean value of TRUE/FALSE, FALSE is the default. TRUE
will return the use of \code{ggplot2::geom_rug()}}

\item{.geom_smooth}{A Boolean value of TRUE/FALSE, FALSE is the default. TRUE
will return the use of \code{ggplot2::geom_smooth()} The \code{aes} parameter of group is
set to FALSE. This ensures a single smoothing band returned with SE also set to
FALSE. Color is set to 'black' and \code{linetype} is 'dashed'.}

\item{.geom_jitter}{A Boolean value of TRUE/FALSE, FALSE is the default. TRUE
will return the use of \code{ggplot2::geom_jitter()}}

\item{.interactive}{A Boolean value of TRUE/FALSE, FALSE is the default. TRUE
will return an interactive \code{plotly} plot.}
}
\value{
A ggplot or a plotly plot.
}
\description{
This is an auto plotting function that will take in a \code{tidy_}
distribution function and a few arguments, one being the plot type, which is
a quoted string of one of the following:
\itemize{
\item \code{density}
\item \code{quantile}
\item \code{probablity}
\item \code{qq}
}

If the number of simulations exceeds 9 then the legend will not print. The plot
subtitle is put together by the attributes of the table passed to the function.
}
\details{
This function will spit out one of the following plots:
\itemize{
\item \code{density}
\item \code{quantile}
\item \code{probability}
\item \code{qq}
}
}
\examples{
tidy_normal(.num_sims = 5) |>
  tidy_four_autoplot()

}
\seealso{
Other Autoplot: 
\code{\link{bootstrap_stat_plot}()},
\code{\link{tidy_autoplot}()},
\code{\link{tidy_combined_autoplot}()},
\code{\link{tidy_multi_dist_autoplot}()},
\code{\link{tidy_random_walk_autoplot}()}
}
\author{
Steven P. Sanderson II, MPH
}
\concept{Autoplot}
